
#version 430 core

layout(location = 0) out float occlusion;
  
in vec2 TexCoords;

uniform sampler2D SSAO;

uniform bool horizontal;
  
uniform float weight[5] = float[] (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

void main()
{             
	
//do occlusion
     vec2 tex_offset = 1.0 / textureSize(SSAO, 0); // gets size of single texel
     float ssaoResult = texture(SSAO, TexCoords).r * weight[0];
     if(horizontal)
     {
         for(int i = 1; i < 5; ++i)
         {
            ssaoResult += texture(SSAO, TexCoords + vec2(tex_offset.x * i, 0.0)).r * weight[i];
            ssaoResult += texture(SSAO, TexCoords - vec2(tex_offset.x * i, 0.0)).r * weight[i];
         }
     }
     else
     {
         for(int i = 1; i < 5; ++i)
         {
             ssaoResult += texture(SSAO, TexCoords + vec2(0.0, tex_offset.y * i)).r * weight[i];
             ssaoResult += texture(SSAO, TexCoords - vec2(0.0, tex_offset.y * i)).r * weight[i];
         }
     }
     occlusion = ssaoResult;
}

